//
//  MCPConnectionInfo.h
//  MCPostgresPersistence
//
//  Created by Michael Clark on 28/08/08.
//  Copyright 2008 Marketcircle Inc.. All rights reserved.
//

#import <Foundation/Foundation.h>


extern NSString*  kMCPDatabaseNameConnectionInfoKey;
extern NSString*  kMCPDatabaseSchemaName;
extern NSString*  kMCPUserNameConnectionInfoKey;
extern NSString*  kMCPPasswordConnectionInfoKey;

extern NSString*  kMCPHostAddressesConnectionInfoKey;
extern NSString*  kMCPHostPortConnectionInfoKey;

extern NSString*  kMCPDatabaseUUIDConnectionInfoKey;
extern NSString*  kMCPConnectionUUIDConnectionInfoKey;


@interface MCPConnectionInfo : NSObject {
	NSMutableDictionary*   __storage;
}

- (id)init;

// Conveniences to store a single address to the hostAddresses array
- (NSString*)hostAddress;
- (void)setHostAddress: (NSString*)anAddress;

- (NSArray*)hostAddresses;
- (void)setHostAddresses:  (NSArray*)theAddresses;

- (NSNumber*)portNumber;
- (void)setPortNumber: (NSNumber*)aPortNumber;

// The port methods wrap the portNumber methods as a convenience
- (int)port;
- (void)setPort: (int)aPort;

- (NSString*)connectionUUID;
- (void)setConnectionUUID: (NSString*)aConnectionUUID;

- (NSString*)databaseUUID;
- (void)setDatabaseUUID: (NSString*)aDatabaseUUID;

- (NSString*)databaseName;
- (void)setDatabaseName: (NSString*)aDatabaseName;

- (NSString *)schemaName;
- (void)setSchemaName:(NSString *)aSchemaName;

- (NSString*)userName;
- (void)setUserName: (NSString*)aUserName;

// WARNING: It is not safe to store plain text passwords in memory - it is a security hole.
//  It is suggested that db specific subclasses override the setPassword: method and convert the passed in string to a hashed value the db system supports, i.e. a md5 or equivalent
- (NSString*)password; // Could be the hashed value as opposed to the real value passed in
- (void)setPassword: (NSString*)aPassword;

- (NSDictionary*)plistRepresentation;
- (id)initWithPlistRepresentation:(NSDictionary *)plist;

- (NSURL *)urlRepresentation;

+ (MCPConnectionInfo *)connectionInfoWithPlistRepresentation:(NSDictionary *)plist;

@end
